(ns burningswell.api.search
  (:require [burningswell.api.hal :as hal]
            [burningswell.api.schemas :refer :all]
            [burningswell.api.spots :refer [enhance-spots]]
            [burningswell.db.search :as search]
            [burningswell.db.util :refer [zip-by-id]]
            [burningswell.http.response :refer [created ok]]
            [plumbing.core :refer :all]
            [schema.core :as s]))

(defnk $autocomplete$GET
  "Autocomplete search."
  {:responses {200 [s/Any]}}
  [[:request query-params :- SearchParams]
   [:resources api-client db]]
  (ok (search/autocomplete db query-params)))

(defnk $details$GET
  "Detail search."
  {:responses {200 [s/Any]}}
  [[:request query-params :- SearchParams]
   [:resources api-client db]]
  (let [details (search/details db query-params)
        spots (filter #(= (:type %) :spot) details)
        spots (enhance-spots api-client db spots query-params)
        spots (zip-by-id spots)]
    (ok (map (fn [{:keys [id type] :as result}]
               (if (= type :spot)
                 (get spots id)
                 result))
             details))))
