(defproject burningswell/api "0.1.25"
  :description "The Burning Swell API"
  :url "https://bitbucket.org/burningswell/api"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[buddy/buddy-auth "0.9.0"]
                 [burningswell/api-client "0.0.38"]
                 [burningswell/config "0.1.27"]
                 [burningswell/core "0.0.35"]
                 [burningswell/db "0.0.69"]
                 [burningswell/http-server "0.1.10"]
                 [burningswell/rabbitmq "0.1.10"]
                 [ch.qos.logback/logback-classic "1.1.6"]
                 [clj-http "2.1.0"]
                 [geo-clj "0.5.0"]
                 [hal-clj "0.1.12"]
                 [hiccup "1.0.5"]
                 [http-kit "2.1.19"]
                 [metosin/ring-http-response "0.6.5"]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/core.cache "0.6.4"]
                 [org.omcljs/om "1.0.0-alpha31"]
                 [prismatic/fnhouse "0.2.1"]
                 [prismatic/plumbing "0.5.2"]
                 [prismatic/schema "1.0.5"]
                 [ring-cors "0.1.7"]
                 [ring/ring-core "1.4.0"]
                 [ring/ring-defaults "0.2.0"]
                 [ring/ring-json "0.4.0"]
                 [rm-hull/inkspot "0.0.1-SNAPSHOT"]
                 [routes-clj "0.1.10"]]
  :plugins [[lein-environ "1.0.2"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :eastwood {:config-files ["test-resources/eastwood.clj"]
             :exclude-linters [:deprecations]}
  :main ^{:skip-aot true} burningswell.api.main
  :profiles {:dev {:dependencies [[clj-http-fake "1.0.2"]
                                  [reloaded.repl "0.2.1"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-cloverage "1.0.6"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :repl-options {:init-ns user}
                   :source-paths ["dev" "src"]}
             :test {:env {:bs-db-name "burningswell_test"
                          :bs-db-password "scotch"
                          :bs-db-scheme "postgresql"
                          :bs-db-server-name "localhost"
                          :bs-db-server-port "5432"
                          :bs-db-user "tiger"}
                    :source-paths ^:replace ["src"]
                    :resource-paths ["test-resources"]}
             :uberjar {:aot :all :main burningswell.api.main}}
  :uberjar-name "burningswell-api.jar")
