(ns burningswell.api.system
  (:require [burningswell.api.client :as client]
            [burningswell.kafka.producer :as producer]
            [burningswell.api.jwt :as jwt]
            [burningswell.api.logger :as logger]
            [burningswell.api.metrics :as metrics]
            [burningswell.api.publisher :as publisher]
            [burningswell.api.server :as server]
            [burningswell.db.connection :as db]
            [peripheral.core :refer [defsystem+]]))

(defsystem+ Api
  []
  :client []
  :db [:metrics]
  :jwt []
  :logger []
  :metrics []
  :producer []
  :publisher [:producer]
  :server [:db :client :jwt :metrics :publisher])

(defn system
  "Return a new system."
  [{:keys [api-client db logger kafka jwt web worker] :as config}]
  (map->Api
   {:client (client/client api-client)
    :db (db/new-db db)
    :jwt (jwt/jwt jwt)
    :logger (logger/logger {:level :info})
    :metrics (metrics/metrics)
    :publisher (publisher/kafka kafka)
    :producer (producer/producer kafka)
    :server (server/map->Server config)
    :web web}))
