(ns burningswell.api.search
  (:require [burningswell.api.core :as core]
            [burningswell.api.middleware.conform :as conform]
            [burningswell.db.search :as search]
            [claro.data :as data]
            [clojure.spec.alpha :as s]))

(s/def :burningswell.api.searchs/params
  (s/keys :opt-un [:burningswell.api.pagination/after
                   :burningswell.api.pagination/before
                   :burningswell.api.pagination/first
                   :burningswell.api.pagination/last
                   :burningswell.api.search/min-spots
                   :burningswell.api.search/query
                   :burningswell.api.specs/distance
                   :burningswell.api.specs/location]))

(defrecord Search [after before distance first last location
                   min-spots sort query]
  conform/Params
  (conform [params env]
    :burningswell.api.searchs/params)

  data/Resolvable
  (resolve! [params {:keys [db]}]
    (->> {:limit (core/limit params)
          :min-spots min-spots
          :offset (core/offset params)
          :query query}
         (search/search db))))
