(ns burningswell.api.publisher
  (:refer-clojure :exclude [test])
  (:require [burningswell.api.middleware.commands :as commands]
            [burningswell.transit :as transit]
            [burningswell.api.middleware.events :as events]
            [burningswell.kafka.producer :as producer]
            [peripheral.core :refer [defcomponent]]
            [taoensso.timbre :as log]))

(def commands-topic
  "burningswell.api.commands")

(def events-topic
  "burningswell.api.events")

(defcomponent Kafka [brokers]
  :this/as *this*
  :log (log/info "Kafka publisher successfully started."))

(extend-type Kafka
  commands/Publisher
  (-publish [publisher command]
    (producer/send! (:producer publisher) commands-topic (:id command) command)
    (log/debug {:msg "Sucessfully published command." :command command}))

  events/Publisher
  (-publish [publisher event]
    (producer/send! (:producer publisher) events-topic (:id event) event)
    (log/debug {:msg "Sucessfully published event." :event event})))

(defcomponent Test []
  :commands (atom [])
  :events (atom []))

(defn- marshal [x]
  (let [opts {:format :json}]
    (-> (transit/encode x opts)
        (transit/decode opts))))

(extend-type Test
  commands/Publisher
  (-publish [publisher command]
    (swap! (:commands publisher) conj (marshal command)))

  events/Publisher
  (-publish [publisher event]
    (swap! (:events publisher) conj (marshal event))))

(defn kafka
  "Returns a Kafka publisher component."
  [config]
  (map->Kafka config))

(defn test
  "Returns a Test publisher component."
  [& [config]]
  (map->Test config))
