(ns burningswell.api.ports
  (:require [burningswell.api.core :as core]
            [burningswell.api.middleware.conform :as conform]
            [burningswell.api.middleware.identifier :as identifier]
            [burningswell.api.specs :as specs]
            [burningswell.api.validation :as v]
            [burningswell.db.ports :as ports]
            [claro.data :as data]
            [clojure.spec.alpha :as s]))

(s/def :burningswell.api.ports/id
  (s/and ::specs/id (v/db-id-exists? :ports)))

(s/def :burningswell.api.ports/except
  (s/nilable (s/coll-of :burningswell.api.ports/id)))

(s/def :burningswell.api.ports/countries
  (s/nilable (s/coll-of :burningswell.api.countries/id)))

(s/def :burningswell.api.ports/regions
  (s/nilable (s/coll-of :burningswell.api.regions/id)))

(s/def :burningswell.api.ports/params
  (s/keys :opt-un [:burningswell.api.pagination/after
                   :burningswell.api.pagination/before
                   :burningswell.api.pagination/first
                   :burningswell.api.pagination/last
                   :burningswell.api.specs/location
                   :burningswell.api.specs/direction
                   :burningswell.api.specs/distance
                   :burningswell.api.search/query
                   :burningswell.api.ports/countries
                   :burningswell.api.ports/except
                   :burningswell.api.ports/regions
                   :burningswell.api.ports/sort]))

(defrecord Port [id name country region]
  conform/Params
  (conform [params env]
    (s/keys :req-un [:burningswell.api.specs/id]))

  identifier/Identifier
  (identifier [_ _]
    {:type :port
     :columns [:id]})

  data/Resolvable
  data/BatchedResolvable
  (resolve-batch! [_ {:keys [db]} ports]
    (ports/select-batch db ports)))

(defrecord Ports [after before countries direction distance except
                  first last location regions sort query]
  conform/Params
  (conform [params env]
    :burningswell.api.ports/params)

  data/Resolvable
  (resolve! [params {:keys [db]}]
    (->> {:countries countries
          :direction direction
          :distance distance
          :except except
          :limit (core/limit params)
          :location location
          :offset (core/offset params)
          :query query
          :regions regions
          :sort sort}
         (ports/search db))))
