(ns burningswell.api.page-views
  (:require [burningswell.api.middleware.commands :as commands]
            [burningswell.api.middleware.conform :as conform]
            [burningswell.api.middleware.events :as events]
            [burningswell.api.specs :as specs]
            [claro.data :as data]
            [clojure.spec.alpha :as s]))

;; Input

(s/def :burningswell.api.page-views.create/input
  (s/keys :req-un [:burningswell.api.specs/url
                   :burningswell.api.specs/session-id]
          :opt-un [:burningswell.api.specs/location]))

(s/def :burningswell.api.page-views/create
  (s/keys :req-un [:burningswell.api.page-views.create/input]))

(defrecord Create [input]
  commands/Command
  (command [resolvable env]
    {:name :burningswell.api.commands/create-page-view})

  conform/Params
  (conform [params env]
    :burningswell.api.page-views/create)

  data/Mutation
  data/Resolvable
  (resolve! [params {:keys [user]}]
    (assoc (:input params) :user-id (:id user)))

  events/Events
  (events [resolvable {:keys [user]} result]
    [{:name :burningswell.api.events/page-view-created
      :location (:location result)
      :session-id (:session-id result)
      :url (:url result)}]))
