(ns burningswell.api.metrics
  (:require [iapetos.collector.jvm :as jvm]
            [iapetos.collector.ring :as ring]
            [iapetos.core :as prometheus]
            [peripheral.core :refer [defcomponent]]))

(defn- make-registry
  "Register the metric collectors."
  [metrics]
  (-> (iapetos.core/collector-registry)
      (jvm/initialize)
      (ring/initialize)))

(defcomponent Metrics []
  :this/as *this*
  :registry (make-registry *this*))

(defn metrics
  "Returns a metrics component."
  [& [config]]
  (map->Metrics config))
