(defproject burningswell/api-client "0.0.39"
  :description "The Burning Swell API client library."
  :url "https://github.com/burningswell/api-client"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.0.0"
  :dependencies [[com.cognitect/transit-clj "0.8.285"]
                 [com.cognitect/transit-cljs "0.8.237"]
                 [geo-clj "0.5.0"]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/clojurescript "1.7.228" :scope "provided"]
                 [request-clj "0.2.20"]]
  :aliases {"ci" ["do" ["test"] ["doo" "phantom" "test" "once"] ["lint"]]
            "lint" ["do"  ["eastwood"]]
            "test" ["do" ["test"] ["doo" "phantom" "test" "once"]]}
  :cljsbuild {:builds [{:id "test"
                        :compiler {:main 'burningswell.api.test
                                   :optimizations :none
                                   :output-to "target/testable.js"
                                   :pretty-print true}
                        :source-paths ["src" "test"]}]}
  :deploy-repositories [["releases" :clojars]]
  :profiles {:dev {:dependencies [[com.cemerick/piggieback "0.2.1"]
                                  [doo "0.1.6"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-cljsbuild "1.1.0"]
                             [lein-difftest "2.0.0"]
                             [lein-doo "0.1.6"]]}})
