(ns user
  (:require
   [clojure.java.io :as io]
   [clj-time.core :as t]
   [buddy.sign.jws :as jws]
   [buddy.core.keys :as keys]))

;; (def ec-privkey (keys/private-key "test/_files/privkey.ecdsa.pem" "secret"))
;; (def ec-pubkey (keys/public-key "test/_files/pubkey.ecdsa.pem"))

(defn- private-key []
  (keys/private-key
   (io/resource "_files/privkey.ecdsa.pem") "secret"))

(defn- public-key []
  (keys/public-key
   (io/resource "_files/pubkey.ecdsa.pem")))

(defn new-token
  [res]
  (let [exp (t/plus (t/now) (t/days 1))]
    (jws/sign res (private-key) {:alg :es512 :exp exp})))

(defn from-token
  [token]
  (try
    (jws/unsign token (public-key))
    (catch Exception e
      (do (prn e)
          nil
          ))))

(comment
  (def token (new-token {:foo "bar"}))
  (jws/unsign token (pubkey))
  )
