(ns clj-fast.set
  #_(:require
   [clj-fast.core :refer [dissoc*]]))

#_(defn rename-keys
  "Returns the map with the keys in kmap renamed to the vals in kmap"
  [map kmap]
  (reduce
   (fn [m kv]
     (let [old (key kv) new (val kv)]
       (if (contains? map old)
         (assoc m new (get map old))
         m)))
   (apply dissoc* map (keys kmap))
   kmap))


#_(comment
  (require '[criterium.core :as cc])
  (def m {:a 1 :b 2 :c 3 :d 4 :e 5})
  (def mm {:a :A :b :B :c :C})
  (cc/bench (clojure.set/rename-keys m mm))
  (cc/bench (rename-keys m mm))
  )
