(ns etsy.api.listing
  (:require [etsy.client :refer [api-call]]))

;; https://www.etsy.com/developers/documentation/reference/listing

;; TODO: Look into whether or not these should be implemented as multimethods

;; TODO: Implement OAuth
;; I realized this requires OAuth only after writing the function, so
;; I need to look into how to implement OAuth before actually finishing
;; this function. Also, other API calls that require OAuth are being skipped
;; for now...
#_(defn create-listing
  "Takes a map of keys and creates a listing. Requires OAuth

  Required keys: quantity, title, description, price, category-id, who-made,
  Optional keys: materials, shipping-template-id, shop-section-id, image-ids,
                 is-customizable, non-taxable, image, state, processing-min,
                 processing-max, tags, recipient, occasion, style

  Etsy's doc:
  Creates a new Listing. NOTE: A shipping_template_id is required when creating
  a listing. NOTE: All listings created on www.etsy.com must be actual items
  for sale. Please see our guidelines[1] for testing with live listings.

  [1] https://www.etsy.com/developers/documentation/getting_started/testing"
  [{:keys [quantity, title, description, price, category-id, who-made,
           materials, shipping-template-id, shop-section-id, image-ids,
           is-customizable, non-taxable, image, state, processing-min,
           processing-max, tags, recipient, occasion, style]
    :or {materials "", shipping-template-id "", shop-section-id "", image-ids "",
         is-customizable "", non-taxable "", image "", state "", processing-min "",
         processing-max "", tags "", recipient "", occasion "", style ""}
    :as params}]
  (api-call :POST (str "/listings") :params params))

(defn find-all-featured-listings
  "Finds all FeaturedTreasury listings."
  [& {:keys [limit offset page region] :as params}]
  (api-call :GET (str "/featured_treasuries/listings") :params params))

(defn get-listing
  "Get listing by listing id"
  [listing-id]
  (api-call :GET (str "/listings/" listing-id)))

#_(defn update-listing)

#_(defn delete-listing)

(defn find-all-listing-active
  "Finds all active Listings.

  Param keys: limit offset page keywords sort-on sort-order min-price max-price
           color color-accuracy tags category location lat lon region geo-level
           accepts-gift-cards translate-keywords

  (Note: the sort_on and sort_order options only work when combined with
one of the search options: keywords, color, tags, location, etc.)"
  [& {:keys [limit offset page keywords sort-on sort-order min-price max-price
           color color-accuracy tags category location lat lon region geo-level
           accepts-gift-cards translate-keywords] :as params}]
  (api-call :GET (str "/listings/active") :params params))

(defn get-interesting-listings
  "Collects the list of interesting listings

  Param keys: limit, offset, page"
  [& {:keys [limit offset page] :as params}]
  (api-call :GET (str "/listings/interesting") :params params))

(defn get-trending-listings
  "Collects the list of listings used to generate the trending listing page

  Param keys: limit, offset, page"
  [& {:keys [limit offset page] :as params}]
  (api-call :GET (str "/listings/trending") :params params))

(defn find-browse-segment-listings
  "Find Listings for a Segment by Segment path. NOTE: Offset must be an integer multiple of limit."
  [path & {:keys [limit offset page keywords sort-on sort-order min-price max-price
                  ship-to location lat lon geo-level accepts-gift-cards]
           :as p}]
  (let [params (assoc p :path path)]
    (api-call :GET (str "/segments/listings") :params params)))

(defn find-all-listings-for-featured-treasury-id
  "Finds all listings for a certain FeaturedTreasury."
  [featured-treasury-id]
  (api-call :GET (str "/featured_treasuries/" featured-treasury-id "/listings")))

;; Seriously? Can't I shorten this??
(defn find-all-active-listings-for-featured-treasury-id
  "Finds all active listings for a certain FeaturedTreasury."
  [featured-treasury-id]
  (api-call :GET (str "/featured_treasuries/" featured-treasury-id "/listings/active")))

(defn find-all-current-featured-listings
  "Finds FeaturedTreasury listings that are currently displayed
  on a regional homepage."
  [& region]
  (api-call :GET (str "/featured_treasuries/listings/homepage_current") :params region))

#_(defn find-all-receipt-listings
  "Finds all listings in a receipt"
  [receipt-id & {:keys [limit offset page] :as params}]
  (api-call :GET (str "/receipts/" receipt-id "/listings") :params params))

(defn find-all-shop-listings-active
  "Finds all active Listings associated with a Shop."
  [shop-id & {:keys [limit offset page keywords sort_on sort_order min_price max_price color color_accuracy tags category translate_keywords include_private] :as params}]
  (api-call :GET (str "/shops/" shop-id "/listings/active") :params params))

#_(defn find-all-shop-listings-draft)

#_(defn find-all-shop-listings-expired)

#_(defn get-shop-listing-expired)

(defn find-all-shop-listings-featured
  "Retrieves Listings associated to a Shop that are featured"
  [shop-id & {:keys [limit offset page] :as params}]
  (api-call :GET (str "/shops/" shop-id "/listings/featured") :params params))

#_(defn find-all-shop-listings-inactive)

#_(defn get-shop-listing-inactive)

(defn find-all-shop-section-listings
  "Finds all listings within a shop section"
  [shop-id shop-section-id & {:keys [limit offset page] :as params}]
  (api-call :GET (str "/shops/" shop-id "/sections/" shop-section-id "/listings")
            :params params))

(defn find-all-shop-listings-active
  "Finds all listings within a shop section"
  [shop-id shop-section-id & {:keys [limit offset page sort-on sort-order] :as params}]
  (api-call :GET (str "/shops/" shop-id "/sections/" shop-section-id "/listings/active")
            :params params))

#_(defn find-all-cart-listings)
