/*
 * Decompiled with CFR 0.152.
 */
package injectthedriver;

import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.Jsoner;
import injectthedriver.DriverFactory;
import injectthedriver.DriverFactoryException;
import injectthedriver.MockClass;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DriverFactoryTest {
    DriverFactoryTest() {
    }

    @Test
    void testEnvVarName() {
        Assert.assertEquals((Object)"JAVA_IO_SERIALIZABLE", (Object)DriverFactory.envVarName(Serializable.class));
    }

    @Test
    void testJSON() throws JsonException {
        String s = "{\"foo\": \"bar\"}";
        Map m = (Map)Jsoner.deserialize((String)s);
        Assert.assertEquals((Object)"bar", (Object)((String)m.get("foo")));
    }

    @Test
    void testGetProperties() throws JsonException, DriverFactoryException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("JAVA_IO_SERIALIZABLE", "{\"foo\": \"bar\", \"pi\": 3.14}");
        Map<String, Object> r = DriverFactory.getProperties(Serializable.class, env);
        Assert.assertEquals((Object)"bar", (Object)r.get("foo"));
    }

    @Test
    void testCreateDriverFor() throws MalformedURLException, DriverFactoryException, ClassNotFoundException, JsonException {
        DriverFactory.ClassLoaderFactory f = (DriverFactory.ClassLoaderFactory)Mockito.mock(DriverFactory.ClassLoaderFactory.class);
        ClassLoader cl = (ClassLoader)Mockito.mock(ClassLoader.class);
        URL jarUrl = new File("my.jar").toURI().toURL();
        Mockito.when((Object)f.createClassLoader(jarUrl)).thenReturn((Object)cl);
        ((ClassLoader)Mockito.doReturn(MockClass.class).when((Object)cl)).loadClass("foo.Bar");
        HashMap<String, String> env = new HashMap<String, String>();
        String json = "{\"jar\": \"my.jar\", \"class\": \"foo.Bar\", \"foo\": \"bar\"}";
        Map props = (Map)Jsoner.deserialize((String)json);
        env.put("JAVA_IO_SERIALIZABLE", json);
        Object driver = DriverFactory.createDriverFor(Serializable.class, env, f);
        ((DriverFactory.ClassLoaderFactory)Mockito.verify((Object)f)).createClassLoader(jarUrl);
        ((ClassLoader)Mockito.verify((Object)cl)).loadClass("foo.Bar");
        Assert.assertThat((Object)driver, (Matcher)CoreMatchers.instanceOf(MockClass.class));
        Assert.assertEquals(((MockClass)driver).props, (Object)props);
    }

    @Test
    void integrationTest() throws IOException, DriverFactoryException {
        String config = "{\"jar\": \"aottest-0.1.0-SNAPSHOT-standalone.jar\", \"class\": \"aottest.Nat\"}";
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("JAVA_UTIL_ITERATOR", config);
        Iterator nat = (Iterator)DriverFactory.createDriverFor(Iterator.class, env, new DriverFactory.ClassLoaderFactory());
    }
}

