(ns bridg.util.uuid
  "Generic helpers for working with UUID's.")

(def uuid-regex
  "Simple, general-purpose UUID regular expression."
  #"[0-9A-Fa-f]{8}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12}")

(defn- string->uuid
  "Casts a string, with or without dashes, to a UUID."
  [data]
  (java.util.UUID/fromString
    (clojure.string/replace
      data
      #"([0-9A-Fa-f]{8})([0-9A-Fa-f]{4})([0-9A-Fa-f]{4})([0-9A-Fa-f]{4})([0-9A-Fa-f]{12})"
      "$1-$2-$3-$4-$5")))

(defprotocol Uuidable
  "Protocol to convert values to a UUID."
  (->uuid [v] "Converts value to a UUID"))

(extend-protocol Uuidable
  java.util.UUID
  (->uuid [v] v)
  java.lang.String
  (->uuid [v] (string->uuid v))
  nil
  (->uuid [v] nil))
