(defproject bridg/sqs "0.2.0-SNAPSHOT"
  :description "A go-to kit for working with AWS SQS in componentized Clojure projects."
  :url "https://github.com/bridg/bridg.sqs"
  :scm {:url "git://github.com/bridg/bridg.sqs.git"}
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.0.0"
  :repositories {"confluent" {:url "http://packages.confluent.io/maven/"}}
  :deploy-repositories [["releases" :clojars]
                        ["snapshots" :clojars]]
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [amazonica "0.3.81" :exclusions [com.amazonaws/aws-java-sdk-logs
                                                  org.clojure/tools.reader]]
                 [bridg/logfmt-component "0.1.0"]
                 [cheshire "5.7.1"]
                 [clj-time "0.13.0"]
                 [com.stuartsierra/component "0.3.1"]
                 [prismatic/schema "1.1.7"]]
  :plugins [[lein-ancient "0.6.10"]
            [lein-cloverage "1.0.6"]
            [lein-environ "1.0.3"]
            [lein-kibit "0.1.2"]])
