(ns bridg.logfmt.ring
  (:require
    [taoensso.timbre :refer [trace debug info warn error]]
    [bridg.logfmt :refer [with-context]]))

(defn wrap-logging [handler]
  (fn [request]
    (let [start    (System/nanoTime)
          method   (name (:request-method request))
          path     (:uri request)]

      ;; Log request
      (info :method method :path path :at "start")

      (let [response (handler request)
            end      (System/nanoTime)
            status   (:status response)
            duration (str (Math/round (float (/ (- end start) 1000000))) "ms")]

        ;; Log response
        (if (and (number? status) (>= status 500))
          (error :method method :path path :status status :at "complete"
                 :duration duration)
          (info  :method method :path path :status status :at "complete"
                 :duration duration))

        response))))
