(ns bridg.logfmt.component
  ^{:doc "Logfmt logging component."}
  (:require
    [com.stuartsierra.component :as component]
    [taoensso.timbre :as timbre]))

(defrecord Logger [config]
  component/Lifecycle
  (start [this]
    (timbre/merge-config! config)
    (timbre/info :msg "Started Logger")
    this)
  (stop [this]
    (timbre/info :msg "Stopped Logger")
    this))

(defn logger [config]
  (->Logger config))
