(ns
  bridg.fixtures
  "Provides functions for loading and unloading fixtures into the DB. Lifted from the
  fixtures-component project at: https://github.com/banzai-inc/fixtures-component

  Protocols from that project are removed. These functions are specific to
  PostgreSQL.

  Provided data should in be format:

      (def data [[:users [{:id 1 :username \"demo1@example.com\"}
                          {:id 2 :username \"demo2@example.com\"}]]
                 [:phones [{:id 1 :user_id 1 :text \"555-383-9999\"}
                           {:id 2 :user_id 2 :text \"555-898-2222\"}]]])
  "
  (:require
    [clj-time.jdbc]
    [clojure.java.jdbc :refer [insert-multi! delete!]]))

(defn- load-table! [spec table records]
  (insert-multi! spec table records))

(defn- clear-table! [spec table]
  (delete! spec table []))

(defn- unload* [spec data]
  (try
    (doseq [[table _] (reverse data)]
      (clear-table! spec table))
    (catch Exception e
      (println (.getMessage e)))))

(defn load!
  [{:keys [spec]} data]
  (try
    (unload* spec data) ;; in case the system failed to unload properly on shutdown
    (doseq [[table records] data]
      (when (not (empty? records))
        (load-table! spec table records)))
    (catch Exception e
      (println (.getMessage e)))))

(defn unload!
  [{:keys [spec]} data]
  (unload* spec data))
