(ns {{namespace}}.tasks.seed.runner
  "Loads seed files into the database. Seeds are inserted directing into the
  database so be aware no business logic code will be called in this process.

  Usage:

      lein with-profiles +task seed fixtures
  "
  (:gen-class)
  (:require
    [bridg.fixtures :as fixtures]
    [{{namespace}}.system :as system]
    [clojure.java.jdbc :as sql]
    [duct.component.ragtime :as ragtime]
    [taoensso.timbre :refer [info error]]))

(defn -main [& args]
  (try
    (let [seeds  args
          system (-> ["{{dirs}}/system.edn"]
                     system/new-system
                     system/start)]
      (info :msg "Starting seed task." :seeds seeds :at "start")
      (-> system :ragtime ragtime/migrate)
      (doseq [seed seeds]
        (info :msg "Loading seed." :seed seed)
        (sql/with-db-transaction [db (get-in system [:db :spec])]
          (fixtures/load! (:db system) seeds/data))))
      (catch Exception e
        (error "Error on seed task." e)
        (System/exit (:exit-code (ex-data e) 1)))
      (finally
        (info :msg "Completed seed task." :at "complete")
        (System/exit 0))))
