(ns bridg.seeds
  "Common functions to help with loading seed data."
  (:require
    [clj-time.jdbc]
    [clojure.edn :as edn]
    [clojure.java.io :as io]
    [clojure.java.jdbc :as sql]
    [duct.component.ragtime :refer [migrate]]))

(defn load-seeds
  "Loads seeds by name from edn."
  [path]
  (let [fullpath (str "{{dirs}}/seeds/" path ".edn")
        content  (slurp (io/resource fullpath))]
    (edn/read-string content)))

(defn load-fixtures [] (load-seeds "fixtures"))
