(ns bridg.seeds
  "Common functions to help with loading seed data."
  (:require
    [cheshire.core :as cheshire]
    [clj-time.core :refer [after?]]
    [clj-time.jdbc]
    [clojure.edn :as edn]
    [clojure.java.io :as io]
    [clojure.java.jdbc :as sql]
    [clojure.test :refer :all]
    [com.stuartsierra.component :as component]
    [compojure.api.sweet :refer [api]]
    [duct.component.ragtime :refer [migrate]]
    [duct.util.system :refer [load-system read-config]]
    [{{namespace}}.system :as system]
    [bridg.fixtures :as fixtures])
  (:import
    [java.util Date]
    [org.joda.time DateTime]))

(defn load-seeds
  "Loads seeds by name from edn."
  [path]
  (let [fullpath (str "{{dirs}}/seeds/" path ".edn")
        content  (slurp (io/resource fullpath))]
    (edn/read-string content)))

(defn load-fixtures [] (load-seeds "fixtures"))
