(ns {{namespace}}.tasks.rollback.runner
  "Performs a database migration.

  Usage:

      lein with-profiles +task rollback
  "
  (:gen-class)
  (:require
    [{{namespace}}.system :as system]
    [duct.component.ragtime :as ragtime]
    [taoensso.timbre :refer [info error]]))

(defn -main []
  (try
    (let [system (-> ["{{dirs}}/system.edn"]
                     system/new-system
                     system/start)]
      (info :msg "Starting rollback database migration task." :at "start")
      (-> system :ragtime ragtime/rollback))
      (catch Exception e
        (error "Error on rollback database migration." e)
        (System/exit (:exit-code (ex-data e) 1)))
      (finally
        (info :msg "Completed rollback database migration." :at "complete")
        (System/exit 0))))
