(ns {{namespace}}.tasks.migrate.runner
  "Performs a database migration.

  Usage:

      lein with-profiles +task migrate
  "
  (:gen-class)
  (:require
    [{{namespace}}.system :as system]
    [duct.component.ragtime :as ragtime]
    [taoensso.timbre :refer [info error]]))

(defn -main []
  (try
    (let [system (-> ["{{dirs}}/system.edn"]
                     system/new-system
                     system/start)]
      (info :msg "Starting migration task." :at "start")
      (-> system :ragtime ragtime/migrate))
      (catch Exception e
        (error "Error on migration." e)
        (System/exit (:exit-code (ex-data e) 1)))
      (finally
        (info :msg "Completed migration." :at "complete")
        (System/exit 0))))
