{{=<< >>=}}
(ns <<namespace>>.endpoint.example
  (:require
    [compojure.api.sweet :refer :all]
    [ring.util.http-response
     :refer [forbidden internal-server-error ok unprocessable-entity]]
    [schema.core :as s]))

(s/defschema Pizza
 {:name s/Str
  (s/optional-key :description) s/Str
  :size (s/enum :L :M :S)
  :origin {:country (s/enum :FI :PO)
           :city s/Str}})

(defn example-endpoint [<<#jdbc?>>{{db :spec} :db}<</jdbc?>><<^jdbc?>>config<</jdbc?>>]
  (routes
    (context "/example" []
             :tags ["example"]

      (GET "/plus" []
        :return {:result Long}
        :query-params [x :- Long, y :- Long]
        :summary "Adds two numbers together"
        (ok {:result (+ x y)}))

      (POST "/echo" []
        :return Pizza
        :body [pizza Pizza]
        :summary "Echoes a Pizza"
        (ok pizza)))))
