## Tasks

The task namespace contains code for implementing administration tasks.


### Administration: The 12th Factor

> One-off admin processes should be run in an identical environment as the
> regular long-running processes of the app. They run against a release, using
> the same codebase and config as any process run against that release. Admin
> code must ship with application code to avoid synchronization issues.
>
> Source: [12Factor: XII. Admin processes](https://12factor.net/admin-processes)


## Creating New Tasks

Entry points for the project need to be AOT compiled, but we want to limit AOT
as we don't want AOT on the REPL.

1. Create a new subdirectory within `src/{{dirs}}/tasks`.
2. Create a namespace named `runner` in the directory.
3. Provide any functionality used by the runner in supporting namespaces, not
   directly in the runner.


## Running Tasks

See: docs/Running-Tasks.md
