(ns {{namespace}}.tasks.kafka-consumer.runner
  "Runs a Kafka consumer. Note: This is not working well with AOT compilation
  which isn't really a problem. Just be sure that you do not use
  `with-profile +task`.

  Usage:

      lein kafka-consumer <consumer-name>
  "
  (:gen-class)
  (:require
    [{{namespace}}.system :as system]
    [duct.component.ragtime :as ragtime]
    [taoensso.timbre :refer [info error]]))

(defn load-var [sym]
  (require (symbol (namespace sym)))
  (find-var sym))

(defn get-active-consumer
  "Gets the active consumer from a system."
  [system]
  (let [active-consumer-key
        (-> system :kafka-consumer :config :active-consumer)]
    (-> system :kafka-consumer :config :consumers active-consumer-key)))

(defn activate-consumer
  "Set configuration in the system to designate which of the consumers defined
  in the (-> system :kafka-consumers :consumers) list is the active one.
  This is required because some state, like consumer group name, is required
  when the consumer component is started. The rest we can provide at subcription
  time."
  [system consumer-name]
  (assoc-in system [:kafka-consumer :config :active-consumer]
            (keyword consumer-name)))

(defn start-consumer-system [sources consumer-name]
  (-> sources
      system/new-system
      (activate-consumer consumer-name)
      system/start))

(defn start-consumer [system consumer-name]
  (let [component (:kafka-consumer system)
        {:keys [topics handler]} (get-active-consumer system)]
    (info :msg "Starting Kafka Consumer task." :consumer-name consumer-name)
    (add-shutdown-hook ::stop-system #(system/stop system))
    (.subscribe!! component topics handler)))

(defn -main [& args]
  (let [consumer-name (first args)
        sources ["{{path}}/system.edn"
                 "{{path}}/consumer_system.edn"]
        system (start-consumer-system sources consumer-name)]
    (start-consumer system consumer-name)))
