(ns {{namespace}}.main
  (:gen-class)
  (:require
    [{{namespace}}.system :as system]
    [com.stuartsierra.component :as component]
    [duct.util.runtime :refer [add-shutdown-hook]]
    [duct.util.system :refer [load-system]]
    [clojure.java.io :as io]))

(defn -main [& args]
  (let [system           (system/new-system ["{{dirs}}/system.edn"])
        initiated-system (system/start system)]
    (println (str "level=info msg=\"Started HTTP server on port\""
                  "port=" (-> system :http :port)
                  "ns={{namespace}}.main"))
    (add-shutdown-hook ::stop-system #(system/stop system))
    initiated-system))
