(ns {{namespace}}.main
  (:gen-class)
  (:require
    [{{namespace}}.system :as system]
    [com.stuartsierra.component :as component]
    [duct.util.runtime :refer [add-shutdown-hook]]
    [duct.util.system :refer [load-system]]
    [clojure.java.io :as io]))

(defn -main [& args]
  (let [system           (system/new-system ["{{dirs}}/system.edn"])
        initiated-system (system/start system)]
    (println "Starting HTTP server on port" (-> system :http :port))
    (add-shutdown-hook ::stop-system #(system/stop system))
    initiated-system))
