(ns {{namespace}}.main
  (:gen-class)
  (:require
    [{{namespace}}.system :as system]
    [com.stuartsierra.component :as component]
    [duct.util.runtime :refer [add-shutdown-hook]]
    [duct.util.system :refer [load-system]]
    [environ.core :refer [env]]
    [clojure.java.io :as io]{{#jdbc?}}{{#heroku?}}
    [hanami.core :as hanami]{{/heroku?}}{{/jdbc?}}))

(defn -main [& args]
  (let [system           (system/new-system ["bridg/metrics/system.edn"])
        initiated-system (system/start system)]
    (println "Starting HTTP server on port" (-> system :http :port))
    (add-shutdown-hook ::stop-system #(system/stop system))
    initiated-system))
