(ns {{namespace}}.system
  "Functions for creating the system."
  (:require
    [clojure.java.io :as io]
    [com.stuartsierra.component :as component]
    [duct.util.runtime :refer [add-shutdown-hook]]
    [duct.util.system :refer [load-system]]
    [environ.core :refer [env]]))

(def system-bindings
  "Define symbols for system bindings. Most often you will want to use this to
  map environment variables to system symbols. Mapped symbols can be inserted
  into the system EDNs."
  {'http-port (Integer/parseInt (:port env "3000")){{#jdbc?}}
   'db-uri    {{^heroku?}}(:database-url env){{/heroku?}}{{#heroku?}}(hanami/jdbc-uri (:database-url env)){{/heroku?}}{{/jdbc?}}}

(defn new-system
  "Creates a new, uninitialized system from the provided resources.
    Example Usage:
        (require '[{{namespace}}.system :as system])
        (system/new-system [\"{{dirs}}/system.edn\"])
  "
  [resource-paths]
  (load-system (keep io/resource resource-paths) system-bindings))

(defn start [system] (component/start system))

(defn stop [system] (component/stop system))
