(ns dev
  (:refer-clojure :exclude [test])
  (:require
    [{{namespace}}.system :as sys]
    [clojure.repl :refer :all]
    [clojure.pprint :refer [pprint]]
    [clojure.tools.namespace.repl :refer [refresh]]
    [clojure.java.io :as io]
    [com.stuartsierra.component :as component]
    [duct.generate :as gen]
    [duct.util.repl :refer [setup test cljs-repl migrate rollback]]
    [duct.util.system :refer [load-system]]
    [reloaded.repl :refer [system init start stop go reset]]))

(when (io/resource "local.clj")
  (load "local"))

(gen/set-ns-prefix '{{namespace}})

(reloaded.repl/set-init!
  (partial sys/new-system ["bridg/metrics/system.edn"
                           "dev.edn"
                           "local.edn"]))
