(ns kafkakit.schema-registry
  "Confluent Schema Registry client. Wraps the Java library. Provides a cached
  local registry client."
  (:require
    [cheshire.core :as json]
    [kafkakit.avro :as avro])
  (:import
    [io.confluent.kafka.schemaregistry.client CachedSchemaRegistryClient]))

(defn cached-client
  "Creates a new cached schema registry client."
  [{:keys [registry-cache-size schema-registry-url]
    :or {registry-cache-size 100}}]
  {:pre [(some? schema-registry-url)]}
  (CachedSchemaRegistryClient. schema-registry-url registry-cache-size))

(defn latest-schema [schema-registry-url subject]
  "Makes an HTTP GET request for the latest version of an Avro schema with
   given name from the schema registry. String response parses into JSON
   and then an Avro schema via Abracad."
  (-> schema-registry-url
      (str "/subjects/" subject "/versions/latest")
      slurp
      (json/parse-string true)
      :schema
      avro/parse-schema))
