(ns kafkakit.consumer.debug-consumer
  "An example debug consumer that prints consumed messages."
  (:require
    [franzy.clients.consumer.protocols :refer [records-by-topic record-count]]
    [kafkakit.avro :as avro]))

(defn handler
  "Handles consumer-records that have been consumed from Kafka."
  [_ topics consumer-record]
  (doseq [topic topics
          record (records-by-topic consumer-record topic)]
    (println record)))
