(defproject bridg/kafkakit "0.1.2"
  :description "A go-to kit for working with Confluent Kafka in componentized Clojure projects."
  :url "https://github.com/bridg/kafkakit"
  :scm {:url "git://github.com/bridg/kafkakit.git"}
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.0.0"
  :repositories {"confluent" {:url "http://packages.confluent.io/maven/"}}
  :deploy-repositories [["releases" :clojars]
                        ["snapshots" :clojars]]
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [bridg/franzy "0.0.4"]
                 [bridg/logfmt-component "0.1.0"]
                 [cheshire "5.7.1"]
                 [clj-time "0.13.0"]
                 [io.confluent/kafka-avro-serializer "3.2.1"]
                 [io.confluent/kafka-schema-registry-client "3.2.1"
                    :exclusions [org.slf4j/slf4j-log4j12
                                 org.scala-lang/scala-library]]
                 [org.apache.avro/avro "1.8.2"]]
  :plugins [[lein-ancient "0.6.10"]
          [lein-cloverage "1.0.6"]
          [lein-environ "1.0.3"]
          [lein-kibit "0.1.2"]])
