(ns plinth.server.jet
  (:require
    [clojure.java.io :as io]
    [plinth.server :as server]
    [qbits.jet.server :as jet]
    [com.stuartsierra.component :as component])
  (:import
    [org.eclipse.jetty.server.handler RequestLogHandler HandlerCollection]
    [ch.qos.logback.access.jetty RequestLogImpl]))

; (:import [org.eclipse.jetty.server.handler.gzip GzipHandler])

; (defn context-configurator
;   [context]
;   (let [gzip-handler (GzipHandler.)]
;     (.setExcludedAgentPatterns gzip-handler (make-array String 0))
;     (.setGzipHandler context gzip-handler))
;   context)

(defn- configurator [server]
  (if-let [logback-access-xml (io/resource "logback-access.xml")]
    (let [^RequestLogHandler handler
          (doto
            (RequestLogHandler.)
            (.setRequestLog
              (doto
                (RequestLogImpl.)
                (.setFileName (.getPath logback-access-xml)))))
          ^HandlerCollection handlers
          (doto
            (HandlerCollection.)
            (.setHandlers (.getHandlers server))
            (.addHandler handler))]
      (doto server
        (.setHandler handlers)))
    server))

(defrecord JetServer [port join? ring-handler]
  component/Lifecycle
  (start [this]
    (assoc this :jetty
      (jet/run-jetty
        { :port port
          :join? (boolean join?)
          :configurator configurator
          :ring-handler (get ring-handler :handler-fn) })))
  (stop [this]
    (when (:jetty this)
      (.stop (:jetty this)))
    (dissoc this :jetty)))

; :websocket-handler - a handler function that will receive a RING request map with the following keys added:

; :in: core.async chan that receives data sent by the client
; :out: core async chan you can use to send data to client
; :ctrl: core.async chan that received control messages such as: [::error e], [::close code reason]
