(ns raid.envelop
  (:require [raid.resources :refer [datetime-float-str gen-etag uuid4]]
            [utcode.core :as utcode])
  (:import raid.exceptions.ActionMissing)
  (:gen-class))

(defn pack-action [p]
  (if-not (get-in p [:header :action])
    (throw (new ActionMissing))
    p))

(defn pack-etag [p]
  (if-not (get-in p [:header :etag])
    (update-in p [:header :etag] (fn [_] (gen-etag)))
    p))

(defn pack-sysdate [p]
  (if-not (contains? p :__sysdate__)
    (update-in p [:header :__sysdate__] (fn [_] (datetime-float-str)))
    p))

(defn pack [p]
  (-> p
      pack-action
      pack-etag
      pack-sysdate
      utcode/encode))

(defn unpack [p]
  (try
    {:ok? true :msg (utcode/decode p)}
    (catch Throwable e
      {:ok? false :err e})))
