(ns raid.socket
  (:refer-clojure :exclude [close write])
  (:import java.net.InetSocketAddress)
  (:gen-class))

(defprotocol ISocket
  (close [this])
  (getAddress [this])
  (write [this msg]))

(defn get-address [^raid.socket.ISocket io]
  (.getAddress io))

(defn get-host [^raid.socket.ISocket io]
  (.getHostName ^java.net.InetSocketAddress (get-address io)))

(defn get-port [^raid.socket.ISocket io]
  (.getPort ^java.net.InetSocketAddress (get-address io)))
