(ns raid.resources
  (:import java.security.MessageDigest
           java.util.UUID)
  (:gen-class))

(defn datetime-float-str []
  (let [d (str (System/currentTimeMillis))]
    (str (subs d 0 10) "." (subs d 10 13))))

(defn- sha-digest [hash data]
  (.digest (MessageDigest/getInstance hash) data))

(defn sha-hash [hash ^String text]
  (->> (.getBytes text "UTF-8")
       (sha-digest hash)
       (map #(format "%x" %))
       (apply str)))

(defn uuid4 []
  (str (UUID/randomUUID)))

(defn gen-etag []
  (sha-hash "SHA-256" (format "[raid::etag-%s]" (uuid4))))
