(ns raid.logging
  (:gen-class))

(defprotocol ILogger
  (addLogger [this handler])
  (getLoggers [this]))

(defn add-logger [^raid.logging.ILogger io handler]
  (.addLogger io handler))

(defn get-loggers [^raid.logging.ILogger io]
  (.getLoggers io))

(defn log-msg
  ([io t msg]
   (log-msg io (get-loggers io) t msg))
  ([io loggers t msg]
   (when (seq loggers)
     (try
       ((first loggers) t msg)
       (catch Exception e))
     (recur io (rest loggers) t msg))))
