# RAID Client

## HOW TO

### CONNECTING TO SERVER

```clojure
(require 'raid.core)

(def connection (raid.core/tcp-connect "localhost" 8888))
```

### REQUESTING

```clojure
(let [{:keys [ok? resp]} @(raid.core/request connection "utos.es.api.utos.timestamp")]
  (println resp))
```

```sh
>>> {
	:body 1517507374
	:header {
		:code "UTOS-00000"
		:etag "f01fea9b4be6de12f0f05adb92fcd33e6ef2a9cba258c460c7d32c18df54"
	}
}
```

# CHANGELOG

## [1.0.0]

* Rewrite TCP client
* Writing multiple messages once
* Fix socket reader discarting messages if server writes too fast
* Remove UDP client (temporary)

## [0.3.8]

* Fix Broken Pipe exception when trying to write on a closed socket

## [0.3.7]

* Queue TCP socket write

## [0.3.6]

* Using augustus lib

## [0.3.5]

* Recipes

## [0.3.4]

* Bug fix - wrong function positioning

## [0.3.3]

* Wait TCP connection to be ready

## [0.3.2]

* Removing NO_DELAY option due Java socket bug

## [0.3.1]

* Bug fix - breakline by message

## [0.3.0]

* Changing TCP lib to java.nio.
* Rewrite thread pool call and thread pool as callback

## [0.2.3]

* Using thread pool to async operations instead of common threads

## [0.2.2]

* Logging handlers

## [0.2.1]

* Using defmulti to call shared functions
* Function "request" created

## [0.2.0]

* Connection object as record
* Separate handlers for messages and exceptions

## [0.1.1]

* Remove "connect" function from tcp/udp
* Base functions for common operations

## [0.0.3]

* Thread start function
* Using macros instead of lambdas

## [0.0.2]

* Some recipes and cancel socket listening

## [0.0.1]

* Socket creation and socket listening
