(ns raid.udp
  (:import [java.net DatagramPacket DatagramSocket InetAddress SocketException])
  (:require [raid.async :as async]
            [raid.base :as base])
  (:gen-class))

(defn create-socket
  ([]
   (DatagramSocket.))
  ([port]
   (DatagramSocket. port)))

(defn- new-pack [size]
  (let [buf (byte-array size)]
    (DatagramPacket. buf size)))

(defn send-msg [socket host port msg]
  (let [buf (.getBytes msg)]
    (.send socket (DatagramPacket. buf (alength buf) (InetAddress/getByName host) port))))

(defn push-msg [this msg]
  (base/push-msg this msg #(send-msg (:socket this) (:host this) (:port this) %)))

(defn- trim-buf [data res]
  (if (= (first data) 0)
    (byte-array res)
    (recur (rest data) (conj res (first data)))))

(defn- parse-pack [pack]
  (String. (trim-buf (.getData pack) [])))

(defn- receive-data [this]
  (try
    (let [pack (new-pack @(:buf-size this))]
      (.receive (:socket this) pack)
      {:ok? true :data (parse-pack pack)})
    (catch SocketException e
      {:ok? false :ex e})))

(defn start-read [this]
  (when-not (deref (:run this))
    (reset! (:run this) true)
    (async/add-callback base/read-data
                        this
                        #(receive-data this))))
