(ns raid.resources
  (:import java.security.MessageDigest
           java.util.UUID)
  (:gen-class))

(defn datetime-float-str []
  (let [d (str (System/currentTimeMillis))]
    (str (subs d 0 10) "." (subs d 10 13))))

(defn sha-hash [hash text]
  (apply str (map #(format "%x" %) (.digest (MessageDigest/getInstance hash) (.getBytes text "UTF-8")))))

(defn uuid4 []
  (str (UUID/randomUUID)))
