(ns raid.logging
  (:gen-class))

(def ^:private logging (atom nil))

(defn set-logging [obj]
  (reset! logging obj))

(defn get-logging []
  (deref logging))

(defn valid-fn [t]
  (and (get-logging) (fn? (t (get-logging)))))

(defmacro info [msg]
  `(if (valid-fn :info)
     ((get (get-logging) :info) ~msg)))
