(ns raid.async
  (:import java.util.concurrent.Executors)
  (:gen-class))

(def ^:private pool (Executors/newCachedThreadPool))

(defn execute* [f]
  (.execute pool f))

(defn add-callback [f & args]
  (execute* (fn [] (apply f args))))

(defmacro execute [& body]
  `(execute* (fn [] (list ~@body))))
