(ns raid.udp
  (:import [java.net DatagramPacket DatagramSocket InetAddress SocketException])
  (:require [raid.base :as base]
            [raid.resources :refer [thread-exec]])
  (:gen-class))

(def default-pack-size (atom (* 1024 1024 512)))

(defn create-socket
  ([]
   (DatagramSocket.))
  ([port]
   (DatagramSocket. port)))

(defn- new-pack [size]
  (let [buf (byte-array size)]
    (DatagramPacket. buf size)))

(defn send-msg [socket host port msg]
  (let [buf (.getBytes msg)]
    (if (base/socket-closed? socket)
      false
      (do
        (.send socket (DatagramPacket. buf (alength buf) (InetAddress/getByName host) port))
        true))))

(defn push-msg [this msg]
  (base/push-msg msg #(send-msg (:socket this) (:host this) (:port this) %)))

(defn- trim-buf [data res]
  (if (= (first data) 0)
    (byte-array res)
    (recur (rest data) (conj res (first data)))))

(defn- parse-pack [pack]
  (String. (trim-buf (.getData pack) [])))

(defn- receive-data [socket]
  (try
    (let [pack (new-pack @default-pack-size)]
      (.receive socket pack)
      {:ok? true :data (parse-pack pack)})
    (catch SocketException e
      {:ok? false :ex e})))

(defn start-read [this]
  (when-not (deref (:run this))
    (reset! (:run this) true)
    (thread-exec base/read-data
                 this
                 #(receive-data (:socket this)))))
