(ns raid.resources
  (:import java.security.MessageDigest
           java.util.UUID
           java.util.concurrent.Executors)
  (:gen-class))

(def ^:private pool (Executors/newCachedThreadPool))

(defn datetime-float-str []
  (let [d (str (System/currentTimeMillis))]
    (str (subs d 0 10) "." (subs d 10 13))))

(defn sha-hash [hash text]
  (apply str (map #(format "%x" %) (.digest (MessageDigest/getInstance hash) (.getBytes text "UTF-8")))))

(defn thread-exec [func & args]
  (.execute pool #(apply func args)))

(defn uuid4 []
  (str (UUID/randomUUID)))
