(ns raid.base
  (:require [raid.envelop :as envelop]
            [raid.logging :as log]
            [raid.recipes :as recipes]
            [raid.resources :refer [thread-exec]])
  (:gen-class))

(defn call-handlers [f handlers]
  (when (seq handlers)
    (f (first handlers))
    (recur f (rest handlers))))

(defn close-socket [socket]
  (future
    (.close socket)
    true))

(defn on-msg [io payload handler]
  (let [{:keys [ok? msg]} (envelop/unpack payload)]
    (if ok?
      (let [action (get-in msg [:header :action])
            handler (or (recipes/actions action) handler)]
        (log/info (format "MSG RECEIVED: %s" msg))
        (thread-exec handler io msg)))))

(defn push-msg [msg sender]
  (let [payload (envelop/pack msg)]
    (if payload
      (do
        (sender payload)
        (log/info (format "MSG SENT: %s" msg)))
      false)))

(defn socket-closed? [socket]
  (.isClosed socket))

(defn read-data [this reader]
  (let [{:keys [ok? data ex]} (reader)]
    (if ok?
      (do
        (call-handlers #(thread-exec on-msg this data %) @(:msg-handlers this))
        (recur this reader))
      (if-not (socket-closed? (:socket this))
        (call-handlers #(thread-exec % this ex) @(:ex-handlers this))))))
