(ns raid.tcp
  (:import [java.net Socket SocketException]
           [java.io PrintWriter InputStreamReader BufferedReader])
  (:require [raid.base :as base]
            [raid.resources :refer [thread-exec]])
  (:gen-class))

(defn reader-buf [socket]
  (BufferedReader. (InputStreamReader. (.getInputStream socket))))

(defn writer-buf [socket]
  (PrintWriter. (.getOutputStream socket) true))

(defn create-socket [host port]
  (doto (Socket. host port)
    (.setTcpNoDelay true)))

(defn send-msg [socket msg]
  (let [writer (writer-buf socket)]
    (if (base/socket-closed? socket)
      false
      (.println writer msg))))

(defn push-msg [this msg]
  (base/push-msg msg #(send-msg (:socket this) %)))

(defn- read-socket [socket]
  (try
    {:ok? true :data (.readLine (reader-buf socket))}
    (catch SocketException e
      {:ok? false :ex e})))

(defn start-read [this]
  (when-not @(:run this)
    (reset! (:run this) true)
    (thread-exec base/read-data
                 this
                 #(read-socket (:socket this)))))
