(ns raid.envelop
  (:require [raid.resources :refer [datetime-float-str uuid4]]
            [utcode.core :as utcode])
  (:gen-class))

(defn pack-body [p]
  (if-not (contains? p :body)
    (assoc p :body {})
    p))

(defn pack-action [h]
  (if-not (contains? h :action)
    (throw (new Exception "action missing"))
    h))

(defn pack-etag [h]
  (if-not (contains? h :etag)
    (assoc h :etag (uuid4))
    h))

(defn pack-sysdate [h]
  (if-not (contains? h :__sysdate__)
    (assoc h :__sysdate__ (datetime-float-str))
    h))

(defn pack-header [h]
  (pack-sysdate (pack-etag (pack-action h))))

(defn pack-payload [p]
  (assoc (pack-body p) :header (pack-header (p :header))))

(defn pack [p]
  (utcode/encode (pack-payload p)))

(defn unpack [p]
  (utcode/decode p))
