(ns raid.base
  (:require [raid.envelop :as envelop]
            [raid.recipes :as recipes]
            [raid.resources :refer [thread-exec]])
  (:gen-class))

(defn call-handlers [f handlers]
  (when (seq handlers)
    (f (first handlers))
    (recur f (rest handlers))))

(defn close-socket [socket]
  (future
    (.close socket)
    true))

(defn on-msg [io payload handler]
  (let [msg (envelop/unpack payload)
        action (get-in msg [:header :action])
        handler (or (recipes/actions action) handler)]
    (thread-exec handler io msg)))

(defn push-msg [msg sender]
  (let [payload (envelop/pack msg)]
    (if payload
      (sender payload)
      false)))

(defn socket-closed? [socket]
  (.isClosed socket))

(defn add-msg-handler [this handler]
  (if (fn? handler)
    (do
      (swap! (:msg-handlers this) conj handler)
      true)
    false))

(defn add-ex-handler [this handler]
  (if (fn? handler)
    (do
      (swap! (:ex-handlers this) conj handler)
      true)
    false))

(defn read-data [this reader]
  (let [{:keys [ok? data ex]} (reader)]
    (if ok?
      (do
        (call-handlers #(thread-exec on-msg this data %) @(:msg-handlers this))
        (recur this reader))
      (if-not (socket-closed? (:socket this))
        (call-handlers #(thread-exec % this ex) @(:ex-handlers this))))))
